<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Role extends Model
{
    protected $table = 'roles';
    protected $primaryKey = 'Role_id';
    public $timestamps = false;

    protected $fillable = [
        'Name',
        'Permissions',
    ];

    protected $casts = [
        'Permissions' => 'array',
    ];

    public function users(): BelongsToMany
    {
        return $this->belongsToMany(User::class, 'user_roles', 'Role_id', 'User_id');
    }
}
